// Dots.h

#ifndef _DOTS_H
#define _DOTS_H

long     Play(void *param);

void	InitializeGroups();
void	NewGroup();
void 	ResetGroups(long inGroup);
void	UpdateGroups();
void	DrawGroups();
long 	GrabDots(long inRequested,long*outStart,long*outEnd);
long	FindFreeGroup();
long 	DotsLeft();
long 	DotsUsed();

void 	FillCosTable();
float 	TableCos(float x);
float 	TableSin(float x);

void	UpdateCircle(long inGroup);
void	UpdateSpiral(long inGroup);
void	UpdateSphere(long inGroup);
void	UpdateClover(long inGroup);
void	UpdateVariableCircle(long inGroup);
void	UpdateEnd(long inGroup);

void	NewCircle(long inGroup, long inType);
void	NewSpiral(long inGroup, long inType);
void	NewSphere(long inGroup, long inType);
void	NewClover(long inGroup, long inType);
void	NewVariableCircle(long inGroup, long inType);
void	NewEnd(long inGroup, long inType);


typedef struct
{
	long	CloverRotation; // Clover Rotation per Cycle
	long	CloverSpacing; // Cycles between new dots
	long	CloverSpeed; // Speed of clover dots
	
	long	VariableSpacing ;
	long	VariableSpeed;
	long	VariableMaxRotation;
	long	VariableChance;
	
	long	SphereDelay;
	long	SphereSpeed;
	
	long	CircleSpacing;
	long	CircleSpeed;
	long	CircleRotation;	
	
	long 	GroupChance;
	long	Erase;
	long	MaxDots;
	long	FrameTime;
	long	MaxGroups;
	
	uint32	screen;
} dots_param;

void	CopySettingsOut(dots_param*);
void	CopySettingsIn(dots_param*);

#endif